//	main.cpp

#include "DFGadget.h"
#include "time.h"
#include "colors.h"
#include "StLocker.h"


enum {
	DF_SHOW_SECONDS = '?SHS'
};


class
Clock : public BApplication
{

public:
					Clock() : BApplication('????'), 
								fGadget(NULL), fMenu(NULL),
								fSeconds(TRUE) {}
					~Clock() { delete fGadget; delete fMenu; }

	virtual void	ReadyToRun();
	virtual void	MessageReceived(BMessage *msg);
	virtual void	Pulse();

protected:
	
	DFGadget		*fGadget;
	BView			*fView;
	BPopUpMenu		*fMenu;
	
	bool			fSeconds;
};


void
Clock::ReadyToRun()
{
	// request gadget
	
	fGadget = new DFGadget(60.0, 60.0);
	
	BBitmap *map = 
		new BBitmap(BRect(0,0,56,9), B_COLOR_8_BIT, TRUE);
	
	fView = new BView(BRect(0,0,56,9), "time", B_FOLLOW_NONE, 0);
	fView->SetLowColor(mdGray);
	map->AddChild(fView);
			
	fGadget->SetBitmap(map);
	fGadget->SetOffset(BPoint(3,5), BPoint(3,13));
	
	SetPulseRate(1e6);
	
	// setup gadget menu
	
	BMenuItem *item = new BMenuItem("Show Seconds", 
							new BMessage(DF_SHOW_SECONDS));
	item->SetMarked(fSeconds);
	item->SetTarget(be_app);
							
	fMenu = new BPopUpMenu("gadgetMenu");
	fMenu->AddItem(item);
	
	fGadget->SetGadgetMenu(fMenu);
}	


void
Clock::MessageReceived(BMessage *message)
{
	switch (message->what) {
	
	case DF_SHOW_SECONDS: {
	
		BMenuItem *item = fMenu->FindItem(DF_SHOW_SECONDS);
		
		StLocker<DFGadget> lock(fGadget);
		
		fSeconds = !fSeconds;
		item->SetMarked(fSeconds);
		
		if (fSeconds)
			fGadget->SetOffset(BPoint(3,5), BPoint(3,14));
		else
			fGadget->SetOffset(BPoint(13,5), BPoint(13,14));
		fGadget->Update();
		}
		break;
	
	default:
		inherited::MessageReceived(message);
		break;
	}
}


void
Clock::Pulse()
{
	if (fGadget) {
	
		StLocker<DFGadget> lock(fGadget);
		
		char time[9];
		time_t tt = __get_time();
		tm *t = localtime(&tt);
		
		if (fSeconds) {
			sprintf(time, "%02d:%02d:%02d", 
				t->tm_hour, t->tm_min, t->tm_sec);
		}
		else {
			sprintf(time, "%02d:%02d", 
				t->tm_hour, t->tm_min);
		}
		
		fView->Window()->Lock();

		fView->FillRect(fView->Bounds(), B_SOLID_LOW);
		fView->DrawString(time, BPoint(0,8));

		fView->Sync();
		
		fView->Window()->Unlock();
		fGadget->Update();
	}
}
			

int
main()
{
	Clock app;

	app.Run();

	return 0;
}
